﻿// This file includes JavaScript functions that are used throughout the site.

// This function hides or shows the beta_content div usingthe blind special effect
function beta_blind()
{
	var beta_content = document.getElementById('beta_content');
	if (beta_content.style.height != "0px")
	{
		new Effect.BlindUp(beta_content); 
	}
	else
	{
		new Effect.BlindDown(beta_content); 
	}
	return false;
}

// This function hides or shows the gamma_content div using both
// the blind and fade special effects.
function gamma_blind()
{
	var gamma_content = document.getElementById('gamma_content');
	if (gamma_content.style.height != "0px")
	{
		new Effect.BlindUp(gamma_content); 
		new Effect.Fade(gamma_content); 
	}
	else
	{
		new Effect.BlindDown(gamma_content); 
		new Effect.Appear(gamma_content); 
	}
	return false;
}

// This script hides or shows the delta_content div and adjust
// the innerHTML element of the delta_title div.
function delta_blind()
{
	var delta_content = document.getElementById('delta_content');
	var delta_title = document.getElementById('delta_title');
	if (delta_content)
	{
		if (delta_content.style.height != "0px")
		{
			new Effect.BlindUp(delta_content); 
			if (delta_title)
				delta_title.innerHTML = 'Collapsed';
		}
		else
		{
			new Effect.BlindDown(delta_content); 
			if (delta_title)
				delta_title.innerHTML = 'Expanded';
		}
	}
	return false;
}

// This script updates eta_content if it is contained on the page.
// This script uses a timer to run every 1 seconds.
function eta_refresh()
{
	if (document.getElementById('eta_content')) 
	{
		Lasso.includeTarget('eta_content', {args: 'target=eta_target'});
		window.setTimeout("eta_refresh()",1000);
	}
}

function nu_cart_draggables()
{
	if (document.getElementById('nu_cart_one'))
		new Draggable('nu_cart_one', {revert:true});
	if (document.getElementById('nu_cart_two'))
		new Draggable('nu_cart_two', {revert:true});
	if (document.getElementById('nu_cart_three'))
		new Draggable('nu_cart_three', {revert:true});
}

function nu_decorate()
{
	new Draggable('nu_item_one', {revert:true});
	new Draggable('nu_item_two', {revert:true});
	new Draggable('nu_item_three', {revert:true});
	nu_cart_draggables();
	Droppables.add('nu_cart', 
		{
			accept:'item', 
			onDrop:function(element){
				Lasso.includeTarget('nu_content', {args: document.getElementById(element.id + '_add'), afterFunc: nu_cart_draggables});
			}
		});
	Droppables.add('nu_trash', 
		{
			accept:'cart', 
			onDrop:function(element) {
				Lasso.includeTarget('nu_content', {args: document.getElementById(element.id + '_rem'), afterFunc: nu_cart_draggables});
			}
		});
}

function list_order(id)
{
	var output = [];
	var element = document.getElementById(id);
	if (element)
	{
		for (var idx = 0; idx < element.childNodes.length; ++idx)
		{
			if (element.childNodes[idx].nodeType == 3) continue;
			var temp = element.childNodes[idx].getAttribute('id');
			if (temp) output.push(temp);
		}
	}
	return output.join(',');
}

function list_decorate()
{
 	Sortable.create('rho_list',
 		{
 			containment:['rho_list'],
			onChange:function(element){
				Lasso.includeTarget('', {args: 'target=none&log=rho:' + list_order('rho_list')});
			}
 		});
	Sortable.create('sigma_list',
		{
			containment:['sigma_list','tau_list'],
			onChange:function(element){
				Lasso.includeTarget('', {args: 'target=none&log=sigma:' + list_order('sigma_list')});
			}
		});
	Sortable.create('tau_list',
		{
			containment:['sigma_list','tau_list'],
			onChange:function(element){
				Lasso.includeTarget('', {args: 'target=none&log=tau:' + list_order('tau_list')});
			}
		});
	Sortable.create('upsilon_list',
		{
			containment:['upsilon_list'],
			tag:'span',
			onChange:function(element){
				Lasso.includeTarget('', {args: 'target=none&log=' + document.getElementById('upsilon_list').innerHTML.replace(/<\/?span.*?>/gi,'')});
			}
		});
}

function zeta_complete()
{
	new Autocompleter.Local('zeta_input', 'zeta_complete', ['one','two','three','four','five','six','seven','eight','nine','ten'], {});
}
